using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.Data;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgCostAccountingReportCriteria
	/// </summary>
	public class DlgCostAccountingReportCriteria : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.GroupBox grpReportCompilation;
		private System.Windows.Forms.RadioButton rdoScheduleJob;
		private System.Windows.Forms.RadioButton rdoCreateNow;
		private System.Windows.Forms.GroupBox grpScheduleJob;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPrinterName;
		private System.Windows.Forms.Label lblPrinterName;
		private System.Windows.Forms.Label lblPrintDate;
		private System.Windows.Forms.DateTimePicker dtpPrintDate;
		private System.Windows.Forms.GroupBox grpDateRange;
		private System.Windows.Forms.Label lblEndDate;
		private System.Windows.Forms.Label lblStartDate;
		private System.Windows.Forms.DateTimePicker dtpStartDate;
		private System.Windows.Forms.DateTimePicker dtpEndDate;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.ComponentModel.IContainer components = null;
		private Form _mdiParent;
		BOL.CostAccountingReport costAccountingReport;

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="mdiParent"></param>
		public DlgCostAccountingReportCriteria(Form mdiParent)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			this._mdiParent = mdiParent;
			
			// Added 1/6/05 RDH
			this.costAccountingReport = new BOL.CostAccountingReport();

			// Added 1/6/05 RDH
			this.LoadPrinters();

			SetComponentProperties();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgCostAccountingReportCriteria));
			this.grpReportCompilation = new System.Windows.Forms.GroupBox();
			this.rdoScheduleJob = new System.Windows.Forms.RadioButton();
			this.rdoCreateNow = new System.Windows.Forms.RadioButton();
			this.grpScheduleJob = new System.Windows.Forms.GroupBox();
			this.cmbPrinterName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblPrinterName = new System.Windows.Forms.Label();
			this.lblPrintDate = new System.Windows.Forms.Label();
			this.dtpPrintDate = new System.Windows.Forms.DateTimePicker();
			this.grpDateRange = new System.Windows.Forms.GroupBox();
			this.lblEndDate = new System.Windows.Forms.Label();
			this.lblStartDate = new System.Windows.Forms.Label();
			this.dtpStartDate = new System.Windows.Forms.DateTimePicker();
			this.dtpEndDate = new System.Windows.Forms.DateTimePicker();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpReportCompilation.SuspendLayout();
			this.grpScheduleJob.SuspendLayout();
			this.grpDateRange.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(392, 30);
			this.vbecsLogo1.TabIndex = 4;
			this.vbecsLogo1.Title = "Cost Accounting Report";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 229);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 6;
			// 
			// grpReportCompilation
			// 
			this.grpReportCompilation.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportCompilation.Controls.Add(this.rdoScheduleJob);
			this.grpReportCompilation.Controls.Add(this.rdoCreateNow);
			this.grpReportCompilation.Controls.Add(this.grpScheduleJob);
			this.grpReportCompilation.Location = new System.Drawing.Point(60, 84);
			this.grpReportCompilation.Name = "grpReportCompilation";
			this.grpReportCompilation.Size = new System.Drawing.Size(326, 121);
			this.grpReportCompilation.TabIndex = 1;
			this.grpReportCompilation.TabStop = false;
			this.grpReportCompilation.Text = "Report Compilation*";
			// 
			// rdoScheduleJob
			// 
			this.rdoScheduleJob.Location = new System.Drawing.Point(16, 40);
			this.rdoScheduleJob.Name = "rdoScheduleJob";
			this.rdoScheduleJob.Size = new System.Drawing.Size(120, 16);
			this.rdoScheduleJob.TabIndex = 1;
			this.rdoScheduleJob.Text = "&Schedule Print Job";
			this.rdoScheduleJob.CheckedChanged += new System.EventHandler(this.rdoScheduleJob_CheckedChanged);
			// 
			// rdoCreateNow
			// 
			this.rdoCreateNow.Checked = true;
			this.rdoCreateNow.Location = new System.Drawing.Point(16, 20);
			this.rdoCreateNow.Name = "rdoCreateNow";
			this.rdoCreateNow.Size = new System.Drawing.Size(124, 16);
			this.rdoCreateNow.TabIndex = 0;
			this.rdoCreateNow.TabStop = true;
			this.rdoCreateNow.Text = "Create Report &Now";
			// 
			// grpScheduleJob
			// 
			this.grpScheduleJob.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpScheduleJob.Controls.Add(this.cmbPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrintDate);
			this.grpScheduleJob.Controls.Add(this.dtpPrintDate);
			this.grpScheduleJob.Enabled = false;
			this.grpScheduleJob.Location = new System.Drawing.Point(8, 40);
			this.grpScheduleJob.Name = "grpScheduleJob";
			this.grpScheduleJob.Size = new System.Drawing.Size(310, 73);
			this.grpScheduleJob.TabIndex = 2;
			this.grpScheduleJob.TabStop = false;
			// 
			// cmbPrinterName
			// 
			this.cmbPrinterName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbPrinterName.Interval = 500;
			this.cmbPrinterName.Location = new System.Drawing.Point(96, 44);
			this.cmbPrinterName.Name = "cmbPrinterName";
			this.cmbPrinterName.Size = new System.Drawing.Size(206, 22);
			this.cmbPrinterName.TabIndex = 3;
			this.cmbPrinterName.SelectedIndexChanged += new System.EventHandler(this.cmbPrinterName_SelectedIndexChanged);
			// 
			// lblPrinterName
			// 
			this.lblPrinterName.Location = new System.Drawing.Point(24, 44);
			this.lblPrinterName.Name = "lblPrinterName";
			this.lblPrinterName.Size = new System.Drawing.Size(76, 20);
			this.lblPrinterName.TabIndex = 2;
			this.lblPrinterName.Text = "Printer Name*";
			this.lblPrinterName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPrintDate
			// 
			this.lblPrintDate.Location = new System.Drawing.Point(24, 20);
			this.lblPrintDate.Name = "lblPrintDate";
			this.lblPrintDate.Size = new System.Drawing.Size(72, 20);
			this.lblPrintDate.TabIndex = 0;
			this.lblPrintDate.Text = "Print Date*";
			this.lblPrintDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpPrintDate
			// 
			this.dtpPrintDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpPrintDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpPrintDate.CustomFormat = "MM/dd/yyyy hh:mm";
			this.dtpPrintDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpPrintDate.Location = new System.Drawing.Point(96, 20);
			this.dtpPrintDate.Name = "dtpPrintDate";
			this.dtpPrintDate.Size = new System.Drawing.Size(206, 20);
			this.dtpPrintDate.TabIndex = 1;
			this.dtpPrintDate.Value = new System.DateTime(2003, 6, 20, 15, 24, 4, 467);
			this.dtpPrintDate.ValueChanged += new System.EventHandler(this.dtpPrintDate_ValueChanged);
			// 
			// grpDateRange
			// 
			this.grpDateRange.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDateRange.Controls.Add(this.lblEndDate);
			this.grpDateRange.Controls.Add(this.lblStartDate);
			this.grpDateRange.Controls.Add(this.dtpStartDate);
			this.grpDateRange.Controls.Add(this.dtpEndDate);
			this.grpDateRange.Location = new System.Drawing.Point(60, 32);
			this.grpDateRange.Name = "grpDateRange";
			this.grpDateRange.Size = new System.Drawing.Size(326, 48);
			this.grpDateRange.TabIndex = 0;
			this.grpDateRange.TabStop = false;
			this.grpDateRange.Text = "Report Date Range";
			// 
			// lblEndDate
			// 
			this.lblEndDate.Location = new System.Drawing.Point(168, 20);
			this.lblEndDate.Name = "lblEndDate";
			this.lblEndDate.Size = new System.Drawing.Size(56, 20);
			this.lblEndDate.TabIndex = 2;
			this.lblEndDate.Text = "End Date*";
			this.lblEndDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblStartDate
			// 
			this.lblStartDate.Location = new System.Drawing.Point(8, 20);
			this.lblStartDate.Name = "lblStartDate";
			this.lblStartDate.Size = new System.Drawing.Size(60, 20);
			this.lblStartDate.TabIndex = 0;
			this.lblStartDate.Text = "Start Date*";
			this.lblStartDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpStartDate
			// 
			this.dtpStartDate.CalendarFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpStartDate.CustomFormat = "MM/dd/yyyy";
			this.dtpStartDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpStartDate.Location = new System.Drawing.Point(68, 20);
			this.dtpStartDate.Name = "dtpStartDate";
			this.dtpStartDate.Size = new System.Drawing.Size(84, 20);
			this.dtpStartDate.TabIndex = 1;
			this.dtpStartDate.Value = new System.DateTime(2004, 4, 7, 0, 0, 0, 0);
			this.dtpStartDate.ValueChanged += new System.EventHandler(this.dtpStartDate_ValueChanged);
			// 
			// dtpEndDate
			// 
			this.dtpEndDate.CalendarFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpEndDate.CustomFormat = "MM/dd/yyyy";
			this.dtpEndDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpEndDate.Location = new System.Drawing.Point(224, 20);
			this.dtpEndDate.Name = "dtpEndDate";
			this.dtpEndDate.Size = new System.Drawing.Size(84, 20);
			this.dtpEndDate.TabIndex = 3;
			this.dtpEndDate.Value = new System.DateTime(2004, 4, 7, 0, 0, 0, 0);
			this.dtpEndDate.ValueChanged += new System.EventHandler(this.dtpEndDate_ValueChanged);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(232, 213);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 2;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			this.btnOK.MouseHover += new System.EventHandler(this.HoverOK);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Location = new System.Drawing.Point(312, 213);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 173);
			this.grpImage.TabIndex = 5;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 1;
			this.pictureBox1.TabStop = false;
			// 
			// DlgCostAccountingReportCriteria
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(392, 245);
			this.Controls.Add(this.grpReportCompilation);
			this.Controls.Add(this.grpDateRange);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpImage);
			this.hlphelpChm.SetHelpKeyword(this, "Cost_Accounting_Report.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(400, 272);
			this.Name = "DlgCostAccountingReportCriteria";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Cost Accounting Report";
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.grpDateRange, 0);
			this.Controls.SetChildIndex(this.grpReportCompilation, 0);
			this.grpReportCompilation.ResumeLayout(false);
			this.grpScheduleJob.ResumeLayout(false);
			this.grpDateRange.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Get/Set StartDate
		/// </summary>
		public DateTime StartDate
		{
			get
			{
				DateTime startDate = new DateTime(this.dtpStartDate.Value.Year,
					this.dtpStartDate.Value.Month,
					this.dtpStartDate.Value.Day,
					0,
					0,
					0);
				return startDate;
			}
			set
			{
				this.dtpStartDate.Value = value;
			}
		}

		/// <summary>
		/// Get/Set EndDate
		/// </summary>
		public DateTime EndDate
		{
			get
			{
				DateTime endDate = new DateTime(this.dtpEndDate.Value.Year,
					this.dtpEndDate.Value.Month,
					this.dtpEndDate.Value.Day,
					23,
					59,
					59);
				return endDate;
			}
			set
			{
				this.dtpEndDate.Value = value;
			}
		}

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC075.DlgCostAccountingReportCriteria());
			//
			this.btnOK.EnabledButton = true;
			this.btnOK.Text = "&OK";
			//
			this.SetThisToolTip(btnCancel,Common.StrRes.Tooltips.Common.Cancel());
			//
			this.dtpStartDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpEndDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpPrintDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
		
			this.dtpEndDate.Value = this.costAccountingReport.EndDate;
			this.dtpStartDate.Value = this.costAccountingReport.StartDate;
			System.DateTime _currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpPrintDate.Value = _currentDate;

			// Added 1/6/05 RDH 
			// Following should cause the ok button to activate/de-activate
			// according to the state of the report object.
			this.costAccountingReport.Valid += new System.EventHandler(this.CheckValid);
			this.costAccountingReport.Invalid += new System.EventHandler(this.CheckValid);
			this.costAccountingReport.IsDirtyChanged += new System.EventHandler(this.CheckValid);

			// TO-DO: Add broken rules for this form.
			//this.costAccountingReport.SetInitialBrokenRules(this.Name);
		}
		
		/// <summary>
		/// Added 1/6/04 RDH
		/// Added method to populate the Printers drop down
		/// list for scheduling.
		/// </summary>
		public void LoadPrinters()
		{
			this.cmbPrinterName.Items.Clear();
			//
			foreach (string printerName in BOL.VbecsReport.GetPrinters())
			{
				cmbPrinterName.Items.Add(printerName);
			}
		}

		private void dtpStartDate_ValueChanged(object sender, System.EventArgs e)
		{
			this.costAccountingReport.StartDate = this.dtpStartDate.Value;
			//
			CheckDates();
		}

		private void dtpEndDate_ValueChanged(object sender, System.EventArgs e)
		{
			this.costAccountingReport.EndDate = this.dtpEndDate.Value;
			//
			CheckDates();
		}

		private void HoverOK(object sender, System.EventArgs e)
		{
			if (this.costAccountingReport.IsValid)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
			}
			else
			{
				this.btnOK.SetToolTip(this.costAccountingReport.GetBrokenRulesMessage(gov.va.med.vbecs.Common.VbecsBrokenRules.ProlongedTransfusionReport.FormClassName));
			}
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			Hashtable dataSource = new Hashtable();
			
			using( WaitCursor _cursor = new WaitCursor() )
			{
				// Added 1/6/05 RDH Setting the date parameters
				this.costAccountingReport.StartDate=this.StartDate;
				this.costAccountingReport.EndDate=this.EndDate;

				// Alerting the user of a possibly long report.
				if (this.costAccountingReport.IsScheduledReportGreaterThanThirtyDays)
				{
					if (DialogResult.Yes != GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.ScheduledReportGreaterThanThirtyDays()))
					{
						return;
					}
				}

				// Added 1/6/05 RDH Scheduling the report.
				if(this.costAccountingReport.IsScheduled)
				{
					// Setting the print scheduling parameters.
					this.costAccountingReport.PrinterName=this.cmbPrinterName.Text;
					this.costAccountingReport.PrintDate=this.dtpPrintDate.Value;

					// Scheduling the report.
					this.costAccountingReport.Schedule();

					this.DialogResult = DialogResult.Cancel;
				}
				// Added 1/6/05 RDH Create the report right now.
				else
				{
					DataTable dtIncomingShipments = costAccountingReport.GetCostAccountingReport(Common.CostAccountingReportSections.IncomingShipment);
					DataTable dtOutgoingShipments = costAccountingReport.GetCostAccountingReport(Common.CostAccountingReportSections.OutgoingShipment);
					DataTable dtUnitModifications = costAccountingReport.GetCostAccountingReport(Common.CostAccountingReportSections.Modifications);
					DataTable dtOffSiteABIDs = costAccountingReport.GetCostAccountingReport(Common.CostAccountingReportSections.OffSiteABID);
					DataTable dtDicardedUnits = costAccountingReport.GetCostAccountingReport(Common.CostAccountingReportSections.DiscardedUnits);
					DataTable dtInactivatedUnits = costAccountingReport.GetCostAccountingReport(Common.CostAccountingReportSections.InactivatedUnits);
					int recordCount = dtIncomingShipments.Rows.Count +
						dtOutgoingShipments.Rows.Count +
						dtUnitModifications.Rows.Count +
						dtOffSiteABIDs.Rows.Count +
						dtDicardedUnits.Rows.Count +
						dtInactivatedUnits.Rows.Count;

					if (recordCount == 0)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC077.NoRecordsFound());
						this.Close();
						return;
					}
					else if(recordCount/10 > 50)
					{
						DialogResult _result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC049.PageCountAlert());
						if( _result != DialogResult.Yes )
						{
							return;
						}
						else
						{
							//Alert user that building report may take a few minutes
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.Warning());
						}
					}

					DataTable dtMainReport = costAccountingReport.GetCostAccountingReport(Common.CostAccountingReportSections.Main);
					DataRow drMainReport = dtMainReport.NewRow();

					if (dtIncomingShipments.Rows.Count == 0)
						drMainReport["IncomingShipmentsVisibleIndicator"] = false;
					else
					{
						drMainReport["IncomingShipmentsVisibleIndicator"] = true;
						dataSource.Add(Common.CostAccountingReportSections.IncomingShipment, dtIncomingShipments);
					}

					if (dtOutgoingShipments.Rows.Count == 0)
						drMainReport["OutgoingShipmentsVisibleIndicator"] = false;
					else
					{
						drMainReport["OutgoingShipmentsVisibleIndicator"] = true;
						dataSource.Add(Common.CostAccountingReportSections.OutgoingShipment, dtOutgoingShipments);
					}

					if (dtUnitModifications.Rows.Count == 0)
					{
						drMainReport["UnitModificationsVisibleIndicator"] = false;
					}
					else
					{
						drMainReport["UnitModificationsVisibleIndicator"] = true;
						dataSource.Add(Common.CostAccountingReportSections.Modifications, dtUnitModifications);
					}

					if (dtOffSiteABIDs.Rows.Count == 0)
						drMainReport["OffSiteABIDsVisibleIndicator"] = false;
					else
					{
						drMainReport["OffSiteABIDsVisibleIndicator"] = true;
						dataSource.Add(Common.CostAccountingReportSections.OffSiteABID, dtOffSiteABIDs);
					}

					if (dtDicardedUnits.Rows.Count == 0)
						drMainReport["DiscardedUnitsVisibleIndicator"] = false;
					else
					{
						drMainReport["DiscardedUnitsVisibleIndicator"] = true;
						dataSource.Add(Common.CostAccountingReportSections.DiscardedUnits, dtDicardedUnits);
					}

					if (dtInactivatedUnits.Rows.Count == 0)
						drMainReport["InactivatedUnitsVisibleIndicator"] = false;
					else
					{
						drMainReport["InactivatedUnitsVisibleIndicator"] = true;
						dataSource.Add(Common.CostAccountingReportSections.InactivatedUnits, dtInactivatedUnits);
					}

					dtMainReport.Rows.Add(drMainReport);

					dataSource.Add(Common.CostAccountingReportSections.Main, dtMainReport);
#if DEBUG				
					/*dtIncomingShipments.DataSet.WriteXml("e:\\temp\\IncomingShipments.xml", XmlWriteMode.WriteSchema);
					dtOutgoingShipments.DataSet.WriteXml("e:\\temp\\OutgoingShipments.xml", XmlWriteMode.WriteSchema);
					dtUnitModifications.DataSet.WriteXml("e:\\temp\\UnitModifications.xml", XmlWriteMode.WriteSchema);
					dtOffSiteABIDs.DataSet.WriteXml("e:\\temp\\OffSiteABIDs.xml", XmlWriteMode.WriteSchema);
					dtDicardedUnits.DataSet.WriteXml("e:\\temp\\DiscardedUnits.xml", XmlWriteMode.WriteSchema);
                    dtInactivatedUnits.DataSet.WriteXml("e:\\temp\\InactivatedUnits.xml", XmlWriteMode.WriteSchema);
					dtMainReport.DataSet.WriteXml("e:\\temp\\CostAccountingMain.xml", XmlWriteMode.WriteSchema);*/
#endif

					FrmCostAccountingReport frm = new FrmCostAccountingReport(dataSource, this.StartDate, this.EndDate);
					frm.MdiParent = this._mdiParent;
					frm.Show();
				}
				

				// Close the form whether the user decides to shedule a report,
				// or create one right now.
				this.Close();
			}
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		// Added 1/6/05 RDH
		private void rdoScheduleJob_CheckedChanged(object sender, System.EventArgs e)
		{
			this.costAccountingReport.IsScheduled=this.rdoScheduleJob.Checked;
			this.grpScheduleJob.Enabled=this.rdoScheduleJob.Checked;
			if ((this.costAccountingReport.IsScheduled) && (this.costAccountingReport.PrintDate == DateTime.MinValue))
			{
				this.dtpPrintDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			}
		}

		// Added 1/6/05 RDH
		private void dtpPrintDate_ValueChanged(object sender, System.EventArgs e)
		{
			if (this.costAccountingReport.IsScheduled)
			{
				this.costAccountingReport.PrintDate = this.dtpPrintDate.Value;
			}
			//
			CheckDates();
		}

		// Added 1/6/05 RDH
		private void cmbPrinterName_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this.costAccountingReport.IsScheduled)
			{
				if(cmbPrinterName.SelectedItem!=null)
				{
					string printer=this.cmbPrinterName.Text;
					for(int i=0; i<this.cmbPrinterName.Items.Count; i++)
					{
						if(printer==this.cmbPrinterName.Items[i].ToString())
						{
							this.costAccountingReport.PrinterName = cmbPrinterName.SelectedItem.ToString();
						}
					}
				}		
				else
				{
					this.costAccountingReport.PrinterName=String.Empty;
				}
			}
		}

		// Added 1/6/04 RDH Copied from UC 48. Used to handle
		// the enabling of the ok button.
		// TO-DO: Added the broken rules for this form.
		private void CheckValid(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = (this.costAccountingReport.IsValid);
		}

		// Added 1/6/2004 Should check and verify dates are
		// correct.
		private void CheckDates()
		{
			if (this.costAccountingReport.StartDate > this.costAccountingReport.EndDate)
			{
				this.errError.SetVbecsError(this.dtpEndDate, Common.StrRes.SysErrMsg.Common.CannotbeGreaterError("Start date", "End date").ResString); // **** 508 Compliance ***
			}
			else
			{
				this.errError.SetVbecsError(this.dtpEndDate, ""); // **** 508 Compliance ***
			}
			//
			if (this.costAccountingReport.IsScheduled)
			{
				if (this.costAccountingReport.EndDate > this.costAccountingReport.PrintDate)
				{
					this.errError.SetVbecsError(this.dtpPrintDate, Common.StrRes.SysErrMsg.Common.CannotbeLessError("Print date", "End date").ResString); // **** 508 Compliance ***
				}
				else
				{
					this.errError.SetVbecsError(this.dtpPrintDate, ""); // **** 508 Compliance ***
				}
			}
			else
			{
				this.errError.SetVbecsError(this.dtpPrintDate, ""); // **** 508 Compliance ***
			}
		}
	}
}

